/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class TemplatePiece
extends TemplateStructurePiece {
    private final int erosion;
    private final boolean cover;
    public static final StructurePieceType INSTANCE = TemplatePiece.setTemplatePieceId(TemplatePiece::new, "template_piece");

    private static StructurePieceType setFullContextPieceId(StructurePieceType structurePieceType, String id) {
        return (StructurePieceType)Registry.m_122965_((Registry)BuiltInRegistries.f_257014_, (ResourceLocation)BCLib.makeID(id), (Object)structurePieceType);
    }

    private static StructurePieceType setTemplatePieceId(StructurePieceType.StructureTemplateType structureTemplateType, String string) {
        return TemplatePiece.setFullContextPieceId((StructurePieceType)structureTemplateType, string);
    }

    public static void ensureStaticInitialization() {
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos centerPos, Rotation rotation, Mirror mirror, BlockPos halfSize) {
        this(structureTemplateManager, resourceLocation, centerPos, rotation, mirror, halfSize, 0, false);
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos centerPos, Rotation rotation, Mirror mirror, BlockPos halfSize, int erosion, boolean cover) {
        super(INSTANCE, 0, structureTemplateManager, resourceLocation, resourceLocation.toString(), TemplatePiece.makeSettings(rotation, mirror, halfSize), TemplatePiece.shiftPos(rotation, mirror, halfSize, centerPos));
        this.erosion = erosion;
        this.cover = cover;
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, CompoundTag compoundTag) {
        super(INSTANCE, compoundTag, structureTemplateManager, resourceLocation -> TemplatePiece.makeSettings(compoundTag));
        this.erosion = compoundTag.m_128441_("E") ? compoundTag.m_128451_("E") : 0;
        this.cover = compoundTag.m_128441_("C") ? compoundTag.m_128471_("C") : true;
    }

    private static BlockPos shiftPos(Rotation rotation, Mirror mirror, BlockPos halfSize, BlockPos pos) {
        halfSize = StructureTemplate.m_74593_((BlockPos)halfSize, (Mirror)mirror, (Rotation)rotation, (BlockPos)halfSize);
        return pos.m_7918_(-halfSize.m_123341_(), 0, -halfSize.m_123343_());
    }

    private static StructurePlaceSettings makeSettings(CompoundTag compoundTag) {
        return TemplatePiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("R")), Mirror.valueOf((String)compoundTag.m_128461_("M")), new BlockPos(compoundTag.m_128451_("RX"), compoundTag.m_128451_("RY"), compoundTag.m_128451_("RZ")));
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation, Mirror mirror, BlockPos halfSize) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74385_(halfSize).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        super.m_183620_(structurePieceSerializationContext, tag);
        tag.m_128359_("R", this.f_73657_.m_74404_().name());
        tag.m_128359_("M", this.f_73657_.m_74401_().name());
        tag.m_128405_("RX", this.f_73657_.m_74407_().m_123341_());
        tag.m_128405_("RY", this.f_73657_.m_74407_().m_123342_());
        tag.m_128405_("RZ", this.f_73657_.m_74407_().m_123343_());
        tag.m_128405_("E", this.erosion);
        tag.m_128379_("C", this.cover);
    }

    protected void m_213704_(String string, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mPos;
        BlockState coverState = null;
        if (this.cover && BlocksHelper.findOnSurroundingSurface((LevelAccessor)world, mPos = new BlockPos(this.f_73383_.m_162395_() - 1, blockPos.m_123342_(), this.f_73383_.m_162398_() - 1).m_122032_(), Direction.DOWN, 8, s -> s.m_204336_(CommonBlockTags.TERRAIN))) {
            mPos.m_122173_(Direction.DOWN);
            coverState = world.m_8055_((BlockPos)mPos);
        }
        super.m_213694_(world, structureManager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(boundingBox.m_162395_(), this.f_73383_.m_162396_(), boundingBox.m_162398_()), (Vec3i)new Vec3i(boundingBox.m_162399_(), this.f_73383_.m_162400_(), boundingBox.m_162401_()));
        if (this.erosion > 0) {
            int x1 = MHelper.min(bounds.m_162399_(), this.f_73383_.m_162399_());
            int x0 = MHelper.max(bounds.m_162395_(), this.f_73383_.m_162395_());
            int z1 = MHelper.min(bounds.m_162401_(), this.f_73383_.m_162401_());
            int z0 = MHelper.max(bounds.m_162398_(), this.f_73383_.m_162398_());
            bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(x0, bounds.m_162396_(), z0), (Vec3i)new Vec3i(x1, bounds.m_162400_(), z1));
            StructureErode.erode(world, bounds, this.erosion, random);
        }
        if (this.cover) {
            StructureErode.cover(world, bounds, random, coverState);
        }
    }
}

